DROP PROCEDURE [hips].[HealthProviderIndividualGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 2 April 2012
-- Description:   Gets a record from the HealthProviderIndividual Table
-- Modified:-
-- 22/10/2012 Andrew Jacks  Changed to work with Hospital and PAS code
--						    HealthProviderIndividualId is not required at the moment
-- 24/04/2012 Simon Biber   Changed LEFT OUTER to INNER joins to avoid locking with transactions
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderIndividualGet] 
(
	@HealthProviderIndividualId INT = NULL,
	@HospitalId INT = NULL,
	@PasProviderIdentifier VARCHAR(30) = NULL
) 
AS
BEGIN
	SELECT
		hcp.HealthProviderIndividualId,
		hcp.IamProviderIdentifier,
		hcp.HpiI,
		hcp.HpiILastValidatedDate,		
		hcp.TitleId,
		t.Description AS Title,		
		hcp.FamilyName,
		hcp.GivenNames,		
		hcp.SuffixId,
		s.Description AS Suffix,
		hcp.DateCreated,
		hcp.UserCreated,
		hcp.DateModified,
		hcp.UserModified
	FROM hips.HospitalHealthProviderIndividual AS hhpi
	INNER JOIN hips.HealthProviderIndividual AS hcp ON hcp.HealthProviderIndividualId = hhpi.HealthProviderIndividualId
	INNER JOIN hips.Title AS t ON t.TitleId = hcp.TitleId
	INNER JOIN hips.Suffix AS s ON s.SuffixId = hcp.SuffixId
	WHERE (@HospitalId = hhpi.HospitalId OR @HospitalId IS NULL)
	AND (@PasProviderIdentifier = hhpi.PasProviderIdentifier OR @PasProviderIdentifier IS NULL)
	AND (@HealthProviderIndividualId = hcp.HealthProviderIndividualId OR @HealthProviderIndividualId IS NULL)
END
GO

